/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class SpellSocketModifier
extends Modifier {
    public static boolean enabled = ModList.get().isLoaded("psi");
    public static final ResourceLocation SOCKET_OWNER = new ResourceLocation("materialis", "socket_owner");
    public static final ValidatedResult SLOT_NOT_EMPTY = ValidatedResult.failure((String)Util.makeTranslationKey((String)"recipe", (ResourceLocation)new ResourceLocation("materialis", "remove_modifier.spell_slot_not_empty")), (Object[])new Object[0]);
    public static final ValidatedResult TOO_MANY_SLOTS = ValidatedResult.failure((String)Util.makeTranslationKey((String)"recipe", (ResourceLocation)new ResourceLocation("materialis", "add_modifier.too_many_spell_slots")), (Object[])new Object[0]);

    public ValidatedResult validate(IToolStackView tool, int level) {
        if (enabled) {
            // empty if block
        }
        return ValidatedResult.PASS;
    }

    public void onRemoved(IToolStackView tool) {
        if (enabled) {
            // empty if block
        }
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (!enabled) {
            return;
        }
        if (!volatileData.contains(SOCKET_OWNER, 8)) {
            volatileData.putString(SOCKET_OWNER, this.getId().toString());
        }
    }

    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (!enabled || !(tool instanceof ToolStack) || this.isOwner(tool.getVolatileData())) {
            // empty if block
        }
    }

    public boolean isOwner(IModDataView volatileData) {
        return this.getId().toString().equals(volatileData.getString(SOCKET_OWNER));
    }
}

